var lasttime = 0; // keep track of the timestamp of last message so we can only ask for new messages
var HISTORY_LENGTH=10; // how much history we want to show on the screen

function sendMessage() {
    if (!$("#nick").val()) {
		alert("please enter a nick to send a message");
		$("#nick").focus();
    }
    else if (!$("#newmsg").val()) {
		alert("but you didn't SAY anything!");
		$("#newmsg").focus();
    }
    else {
		var thenick = $("#nick").val();
		var themsg = $("#newmsg").val();
		var thetime = new Date();
		disableNewMessage();
		
		// add the new message to the screen
		$("#msgs").append('<div class="msg"><span class="timestamp">[' + 
        	formatTime(thetime) + 
            ']</span> <span class="nick">&lt;' + 
            thenick + 
            '&gt;</span> <span class="content">' + themsg + '</span></div>');
			
		// remove any old messages that exceed the history length
		while ($(".msg").length > HISTORY_LENGTH) {
			$(".msg:first").remove();
		}

		enableNewMessage("");
    }
}

// Formatting dates in JavaScript is a pain. But, doing it in
// JS is better than in PHP because it solves the timezone problem
// (i.e. all users get times in their home timezone)
function formatTime(timestamp) {
	var d = new Date(timestamp * 1000);
	var h = d.getHours();
	var m = d.getMinutes();
	var s = d.getSeconds();
	return h + ":" + (m > 10 ? m : "0" + m) + ":" + (s > 10 ? s : "0" + s);	
}

// UI niceties to let the user know we're sending the message
function disableNewMessage() {
    $("#newmsg").attr("disabled", "true");
    $("#newmsg").css("font-style","italic");
    $("#newmsg").val("sending...");
}

function enableNewMessage(msg) {
    $("#newmsg").attr("disabled", "");
    $("#newmsg").css("font-style","");
    $("#newmsg").val(msg);
}

// this will execute at page load
// put the cursor in the "nick" box, and start the update polling process
$(function() { $("#nick").focus(); checkForUpdates(); });

