var lasttime = 0; // keep track of the timestamp of last message so we can only ask for new messages
var HISTORY_LENGTH=10; // how much history we want to show on the screen

// AJAX polling function to check for new messages
function checkForUpdates() {
    var rand = Math.round(Math.random() * 65536);
    var theurl = "get_messages.php";
    $.ajax({
	type: "GET",
	url: "get_messages.php",
	dataType: 'json',
	data: {since:lasttime, rand:rand},
	success: function(json) {
	    setTimeout(checkForUpdates, 1000);
	    processUpdates(json);
	},
	error: function(msg) {
	    setTimeout(checkForUpdates, 5000);
	}
    });

}

// Add any new messages to the screen, keeping only HISTORY_LENGTH lines on the screen
function processUpdates(json) {
    if (json && json.length) {
	for (var i = json.length-1; i >= 0; --i) {
	    $("#msgs").append('<div class="msg"><span class="timestamp">[' + 
			      formatTime(json[i]['time']) + 
			      ']</span> <span class="nick">&lt;' + 
			      json[i]['nick'] + 
			      '&gt;</span> <span class="content">' + json[i]['msg'] + '</span></div>')
	    while ($(".msg").length > HISTORY_LENGTH) {
		$(".msg:first").remove();
	    }
	}
	lasttime = json[0]['time'];
    }
}

function sendMessage() {
    if (!$("#nick").val()) {
	alert("please enter a nick to send a message");
	$("#nick").focus();
    }
    else if (!$("#newmsg").val()) {
	alert("but you didn't SAY anything!");
	$("#newmsg").focus();
    }
    else {
	var themsg = $("#newmsg").val()
	disableNewMessage();
	$.ajax({
	    type: "POST",
	    url: "send_message.php",
	    data: {nick : $("#nick").val(),  msg : themsg},
	    success: function() { enableNewMessage(""); $("#newmsg").focus();},
	    error: function() { enableNewMessage(themsg); alert("error sending your message, please try again"); }
	});
    }
}

// Formatting dates in JavaScript is a pain. But, doing it in
// JS is better than in PHP because it solves the timezone problem
// (i.e. all users get times in their home timezone)
function formatTime(timestamp) {
	var d = new Date(timestamp * 1000);
	var h = d.getHours();
	var m = d.getMinutes();
	var s = d.getSeconds();
	return h + ":" + (m > 10 ? m : "0" + m) + ":" + (s > 10 ? s : "0" + s);	
}

// UI niceties to let the user know we're sending the message
function disableNewMessage() {
    $("#newmsg").attr("disabled", "true");
    $("#newmsg").css("font-style","italic");
    $("#newmsg").val("sending...");
}

function enableNewMessage(msg) {
    $("#newmsg").attr("disabled", "");
    $("#newmsg").css("font-style","");
    $("#newmsg").val(msg);
}

// this will execute at page load
// put the cursor in the "nick" box, and start the update polling process
$(function() { $("#nick").focus(); checkForUpdates(); });

