import React from 'react';
import ReactDOM from 'react-dom';
import { HashRouter, Route, Link } from "react-router-dom";
import './YourPost.css';

class YourPost extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            posttext : "Add a comment...",
            comments : [],
        };

        this.handleText = this.handleText.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    handleSubmit(event) {
        const nc = [...this.state.comments, this.state.posttext];
        this.setState({
            comments: nc,
            posttext : "Add a comment...",
        })


        event.preventDefault();
    }

    handleText(event) {
        this.setState({posttext: event.target.value});
    }

    render() {
        return (
            <div id="middlestuff">
                <img id="postedimage" src='../buttons/whitetop.png' />
                <div id="commentreply">
                    <p className="postcomms"> {"Hey all! Does anyone have a white halter top in medium like this? Happy to trade, buy, or hear recommendations."} </p>

                    <div>
                        {this.state.comments.map((com) => (
                            <p className="postcomms">{com}</p> 
                        ))}
                    </div>

                    <form id="replycomm" onSubmit={this.handleSubmit}>
                        <textarea value={this.state.posttext} onChange={this.handleText}/>

                            <input type="image" src='../buttons/reply.png' />
                    </form>
                </div>
            </div>
        );
    }
}

export default YourPost;