import React from 'react';
import ReactDOM from 'react-dom';
import { HashRouter, Route, Link } from "react-router-dom";
import './TradeRequest.css';

class TradeRequest extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            posttext : "Write a message back to Kevin.",
            comments : [],
        };

        this.handleText = this.handleText.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    handleSubmit(event) {
        const nc = [...this.state.comments, this.state.posttext];
        this.setState({
            comments: nc,
            posttext : "Add a comment...",
        })

        event.preventDefault();
    }

    handleText(event) {
        this.setState({posttext: event.target.value});
    }

    render() {
        return (
            <div id="req">
                <img id="hoodie" src='../buttons/hoodie.png' />

                <div id="allcomms">
                    {this.state.comments.map((com) => (
                        <p className="commentrep">{com}</p> 
                    ))}
                </div>

                <form id="replyreq" onSubmit={this.handleSubmit}>
                    <textarea value={this.state.posttext} onChange={this.handleText}/>

                        <input type="image" src='../buttons/reply.png' />
                </form>
            </div>
        );
    }
}


export default TradeRequest;