import React from 'react';
import './States.css';

/**
 * Define States, a React componment of CS142 project #4 problem #2.  The model
 * data for this view (the state names) is available
 * at window.cs142models.statesModel().
 */
class States extends React.Component {
  constructor(props) {
    super(props);
   
    this.state = {
        states: window.cs142models.statesModel().sort(),
        searchTerm: ''
    };
    
    this.handleStateBound = event => this.handleState(event);  
}

handleState(event) {
    this.setState({searchTerm: event.target.value });
}

filterStates(searchTerm) {  
    console.log(searchTerm)
    let stateList = [];
    for (let i = 0; i < this.state.states.length; i++){  
        if(this.state.states[i].toLowerCase().includes(searchTerm.toLowerCase())) {
            stateList.push(<p key = {this.state.states[i]}>{this.state.states[i]}</p>);
            
        }
    }
  
    if(stateList.length === 0){
        stateList.push(<p>{"No matches!"}</p>)
    }
    return stateList
}


  render() {
    return (
      <div>
        <h1>This will list all states with substring
          &quot;{`${this.state.searchTerm}`}&quot;</h1>
        <p className="state-input">
          <label htmlFor="inIdstate"> Filter states: </label>
          <input
            id="inIdstate"
            type="text"
            defaultValue={this.state.searchTerm}
            onChange={this.handleStateBound}
          />
        </p>

        <div className="filtered-states">
            {this.filterStates(this.state.searchTerm)}
        </div>

      </div>
    
    );
  }
}

export default States;
