import React from 'react';
import ReactDOM from 'react-dom';
import { HashRouter, Route, Link } from "react-router-dom";
import './PrePost.css';

class PrePost extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            updateHeader : props.callback,
            updatePostStatus : props.pv,
            posttext : "Hey all! Does anyone have a white halter top in medium like this? Happy to trade, buy, or hear recommendations.",
        };

        this.handleText = this.handleText.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);

    }

    handleSubmit(event) {
        event.preventDefault();
    }

    handleText(event) {
        this.setState({posttext: event.target.value});
    }

    render() {
        return (
            <div id="midcont">
                <img id="mainimage" src='../buttons/whitetop.png' />

                <form id="formcheck" onSubmit={this.handleSubmit}>
                    <textarea id="textchange" value={this.state.posttext} onChange={this.handleText}/>

                    <Link to="/" onClick={() => {
                        this.state.updateHeader("HOME");
                        this.state.updatePostStatus();
                    }}> 
                        <input id="posttofriends" type="image" src='../buttons/postpost.png' />
                    </Link>
                </form>
            </div>
        );
    }
}


/* TODO (if time): Upload text to dynamicSwitching, then pass in when opening the post */

export default PrePost;