import React from 'react';
import ReactDOM from 'react-dom';
import { HashRouter, Route, Link } from "react-router-dom";
import './PatchRecsForm.css';

class PatchRecsForm extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            updateHeader : props.callback,
            itemDesc : "(Key features I noticed were: halter neck, bodysuit, white, minimal, cotton, classic)",
            retail: false,
            thrift: false,
            resale: false,
            consignment: false,
            brandnew: false,
            likenew: false,
            gentlyused: false,
            signsofwear: false,
            refurbished: false
        };

        this.handleDesc = this.handleDesc.bind(this);
        this.handleInputChange = this.handleInputChange.bind(this);
    }

    handleSubmit(event) {
        console.log(event);
        event.preventDefault();
    }

    handleDesc(event) {
        this.setState({itemDesc: event.target.value});
    }

    handleInputChange(event) {
        console.log(event.target);
        const target = event.target;
        const value = target.type === 'checkbox' ? target.checked : target.value;
        const name = target.name;

        this.setState({
            [name]: value
        });
    }

    render() {
        return (
            <div id="middlecont">
                <img id="patch" src="../buttons/helpfulpatch.png" />

                <form id="sugform" onSubmit={this.handleSubmit}>
                    <div className="questions">
                        <label>
                            <p>I noticed that the item you were looking at had these details:</p>
                            <img src="../buttons/maintags.png" />
                        </label>
                    </div>
                    <div className="questions">
                        <label>
                            <p>What about the item are you interested in?</p>
                            <textarea className="textInput" value={this.state.itemDesc} onChange={this.handleDesc}/>
                        </label>
                    </div>
                    <div className="questions">
                        What is your price range?
                        <img style={{width: "300px", height: 'auto'}} src="../buttons/pricerange.png" />
                    </div>
                    <div className="questions">
                        <p>What types of retailers can I look at?</p>
                            <label>
                                <input type="checkbox" name="retail" checked={this.state.retail} onChange={this.handleInputChange}/>
                                retail    
                            </label> <div />
                            <label>
                                <input type="checkbox" name="thrift" checked={this.state.thrift} onChange={this.handleInputChange}/>
                                thrift    
                            </label> <div />
                            <label>
                                <input type="checkbox" name="resale" checked={this.state.resale} onChange={this.handleInputChange}/>
                                resale    
                            </label> <div />
                            <label>
                                <input type="checkbox" name="consignment" checked={this.state.consignment} onChange={this.handleInputChange}/>
                                consignment    
                            </label> <div />
                    </div>
                    <div className="questions">
                        <p>What condition can the item be in?</p>
                            <label>
                                <input type="checkbox" name="brandnew" checked={this.state.brandnew} onChange={this.handleInputChange}/>
                                brand new    
                            </label> <div />
                            <label>
                                <input type="checkbox" name="likenew" checked={this.state.likenew} onChange={this.handleInputChange}/>
                                like new    
                            </label> <div />
                            <label>
                                <input type="checkbox" name="gentlyused" checked={this.state.gentlyused} onChange={this.handleInputChange}/>
                                gently used    
                            </label> <div />
                            <label>
                                <input type="checkbox" name="signsofwear" checked={this.state.signsofwear} onChange={this.handleInputChange}/>
                                signs of wear    
                            </label> <div />
                            <label>
                                <input type="checkbox" name="refurbished" checked={this.state.refurbished} onChange={this.handleInputChange}/>
                                refurbished    
                            </label> <div />                            
                    </div>


                    <Link id="nextstep" className="questions" to="/patchrecsout" onClick={() => this.state.updateHeader("PATCH'S SUGGESTIONS") }> 
                        <input style={{width: "200px", height: "auto"}} type="image" src='../buttons/searchforstyles.png' />
                    </Link>
                </form>
            </div>
        );
    }
}

export default PatchRecsForm;