import React from 'react';
import ReactDOM from 'react-dom';
import { HashRouter, Route, Link } from "react-router-dom";
import './NewPost.css';

class NewPost extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            updateHeader : props.callback,
            itemDesc : "Describe key features here (halter top, white, ...)",
            attachlink : "Paste the link here and we can pull out the image",
            shareTo: "friends",
            shareOps: "sugg"
        };

        this.handlesharingchange = this.handlesharingchange.bind(this);
        this.handletypechange = this.handletypechange.bind(this);
        this.handleDesc = this.handleDesc.bind(this);
        this.handleUrl = this.handleUrl.bind(this);

    }

    handleSubmit(event) {
        console.log(event);
        event.preventDefault();
    }

    handleDesc(event) {
        this.setState({itemDesc: event.target.value});
    }

    handleUrl(event) {
        this.setState({attachlink: event.target.value});
    }

    handlesharingchange(event) {
        this.setState({shareTo: event.target.value});
    }

    handletypechange(event) {
        this.setState({shareOps: event.target.value});
    }

    render() {
        return (
            <div id="midcont">
                <img id="patch" src="../buttons/helpfulpatch.png" />

                <form id="recform" onSubmit={this.handleSubmit}>
                    <div className="question">
                        <label>
                            <p>Tell me about what you're looking for</p>
                            <input className="textIn" type="text" value={this.state.itemDesc} onChange={this.handleDesc}/>
                        </label>
                    </div>
                    <div className="question">
                        <label>
                            <p>Is there an example you could past the link to?</p>
                            <input className="textIn" type="text" value={this.state.attachlink} onChange={this.handleUrl}/>
                        </label>
                    </div>
                    <div className="question">
                        Who will be able to see your post?
                        <div>
                            <label>
                                <input type="radio" value="friends" checked={this.state.shareTo === 'friends'} onChange={this.handlesharingchange}/>
                                My Patchmates
                            </label>
                        </div>
                        <div>
                            <label>
                                <input type="radio" value="all" checked={this.state.shareTo === 'all'} onChange={this.handlesharingchange}/>
                                Everyone (Public)
                            </label>
                        </div>
                    </div>
                    <div className="question">
                        What types of responses do yout want?
                        <div>
                            <label>
                                <input type="radio" value="trade" checked={this.state.shareOps === 'trade'} onChange={this.handletypechange}/>
                                Offers to trade
                            </label>
                        </div>
                        <div>
                            <label>
                                <input type="radio" value="sugg" checked={this.state.shareOps === 'sugg'} onChange={this.handletypechange}/>
                                Suggestions
                            </label>
                        </div>
                    </div>

                    <Link className="question" id="nextstep" to="/prepost" onClick={() => this.state.updateHeader("PREVIEW POST") }> 
                        <input type="image" src='../buttons/previewpost.png' />
                    </Link>
                </form>
            </div>
        );
    }
}

export default NewPost;