import React from 'react';
import './NavBar.css';
import { HashRouter, Route, Link } from "react-router-dom";
import ReactDOM from 'react-dom';

class NavBar extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            bluehome : props.atHome,
            goHome : props.callback,
        };      
    }

    render() {
        return (
            <div id="navbar">
                <img className="navicon" src="../icons/alert.png" style={{height: "76px", width:"76px"}} />
                { this.state.bluehome ?
                    <img className="navicon" src="../icons/bluefeed.png" style={{height: "70px", width:"70px"}}/>
                :
                    <Link to="/" onClick={() => this.state.goHome()}>
                        <img className="navicon" src="../icons/greyfeed.png" style={{height: "70px", width:"70px"}}/>
                    </Link>
                }
                <img className="navicon" src="../icons/profile.png" style={{height: "55px", width:"55px"}}/>
                <img className="navicon" src="../icons/settings.png" style={{height: "65px", width:"65px"}}/>
            </div>
        );
    }

    componentDidUpdate() {
        if (this.state.bluehome !== this.props.atHome) {
            this.setState({
                bluehome: this.props.atHome,
            });
        }
    }
 }

 export default NavBar;
