import React from 'react';
import ReactDOM from 'react-dom';
import { HashRouter, Route, Link } from "react-router-dom";
import './HomeScreen.css';

class HomeScreen extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            updateHeader : props.callback,
            showOwnPost : props.showOwn,
        };
    }

    render() {
        return (
            <div id="midcont">
                <div id="topblock">
                    <Link className='boxbutton' to="/patchrecsform" onClick={() => this.state.updateHeader("PATCH RECOMMENDS")}>
                        <img src='../buttons/patchsuggestionbutton.png' />
                    </Link>
                    <Link className='boxbutton' to="/newpost" onClick={() => this.state.updateHeader("MAKE A POST")}>
                        <img src='../buttons/patchmaterecs.png' />
                    </Link>
                </div>
                <div id="feed">
                    { this.state.showOwnPost ?
                        <Link className='feeditembutton' to="/yourpost" onClick={() => this.state.updateHeader("YOUR POST")}>
                            <img src='../buttons/yourpost.png' />
                        </Link>
                        :
                        <div />
                    }   
                    <Link className='feeditembutton' to="/tradereq" onClick={() => this.state.updateHeader("TRADE REQUEST")}>
                        <img src='../buttons/kevintrade.png' />
                    </Link>
                    <img className='feeditemimage' src='../buttons/kmswap.png' />
                    <img className='feeditemimage' src='../buttons/gabibought.png' />
                </div>
            </div>
        );
    }

    componentDidUpdate() {
        console.log("checking if post is visible");
        console.log(this.state.showOwnPost);
        console.log(this.props.showOwn)
        if (this.state.showOwnPost !== this.props.showOwn) {
            this.setState({
                showOwnPost : this.props.showOwn
            });
        }
    }
}

export default HomeScreen;