import React from 'react';
import ReactDOM from 'react-dom';
import { HashRouter, Route, Link } from "react-router-dom";
import './DynamicSwitching.css';

import HomeScreen from '../homeScreen/HomeScreen';
import NewPost from '../newPost/NewPost';
import PrePost from '../prePost/PrePost';
import PatchRecsForm from '../patchRecsForm/PatchRecsForm';
import PatchRecsOut from '../patchRecsOut/PatchRecsOut';
import YourPost from '../yourPost/YourPost';
import TradeRequest from '../tradeRequest/TradeRequest';

import NavBar from '../navBar/NavBar';
import Header from '../header/Header';


class DynamicSwitching extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            stateHistory : [],
            currentState : "HOME",
            showOwnPost : false,
        };
        this.updateHeader = this.updateHeader.bind(this);
        this.goBack = this.goBack.bind(this);
        this.postVis = this.postVis.bind(this);
    }

    updateHeader = function(stateName) {
        console.log(this.state.stateHistory);
        const newh = [this.state.currentState, ...this.state.stateHistory];
        this.setState({
            stateHistory: newh,
            currentState: stateName
        });
    }

    goBack = function() {
        const [lastState, ...remainder] = this.state.stateHistory;
        this.setState({
            stateHistory: remainder,
            currentState: lastState,
        });
    }

    pathTo(givenHead) {
        switch(givenHead) {
            case "States":
                return "/states";
            case "Example":
                return "/example";
            case "MAKE A POST":
                return "/newpost";
            case "PREVIEW POST":
                return "/prepost";
            case "PATCH RECOMMENDS":
                return "/patchrecsform";
            case "PATCH'S SUGGESTIONS":
                return "/patchrecsout";
            case "YOUR POST":
                return "/yourpost";
            case "TRADE REQUEST":
                return "/tradereq";
            default:
                return "/";
        }
    }

    postVis = function() {
        console.log("setting post to visible");
        this.setState({showOwnPost: true});
    }

    render() { //should really insert topbar at top, navbar at bottom
        console.log(this.state);
        return (
            <HashRouter>
                <Header hname={this.state.currentState} callback={this.goBack} prevPath={this.state.stateHistory.length > 0 && this.pathTo(this.state.stateHistory[0])}/>

                <Route exact path="/" render={(props) => <HomeScreen className="main" {...props} callback={this.updateHeader} showOwn={this.state.showOwnPost}/>} />
                <Route path="/newpost" render={(props) => <NewPost className="main" {...props} callback={this.updateHeader}/>} />
                <Route path="/prepost" render={(props) => <PrePost className="main" {...props} callback={this.updateHeader} pv={this.postVis}/>} />
                <Route path="/patchrecsform" render={(props) => <PatchRecsForm className="main" {...props} callback={this.updateHeader}/>} />
                <Route path="/patchrecsout" render={(props) => <PatchRecsOut className="main" {...props}/>} />
                <Route path="/yourpost" render={(props) => <YourPost className="main" {...props} />} />
                <Route path="/tradereq" render={(props) => <TradeRequest className="main" {...props} />} />

                <NavBar callback={() => this.updateHeader("HOME")} atHome={this.state.currentState === "HOME"} />
            </HashRouter>
        );
    }

    componentDidUpdate() {
        if (this.props.tochange) {
            this.setState({
                headername: this.props.headername,
            });
        }
    }

}

export default DynamicSwitching;